/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	TranslateAxes.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "CWorkplane.h"
#include "cApplication.h"

// Translates the axes and return the origin
HRESULT TranslateAxes(double xTranslation=0.0, double yTranslation=0.0, IVector **retval=NULL)
{
	START_METHOD("TranslateAxes")
	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)
	
	IVector *pVector1 = NULL;
	status = (GetCLASS(Vector))->CreateVector(xTranslation, yTranslation, 0,&pVector1);
	CHECK_RETURN_STATUS(status)

	IVector *pVector2 = NULL;
	status = activeWorkplane->GetLocalOrigin(&pVector2);
	CHECK_RETURN_STATUS(status)

	IVector *pVector3 = NULL;
	status = pVector1->subtract(CAST(IVectorOrDirection,pVector2), &pVector3);
	CHECK_RETURN_STATUS(status)

	// create matrix translation vector
	IMatrix *pTransMatrix= NULL;
	status = (GetCLASS(Matrix))->CreateTranslationMatrix(pVector3, &pTransMatrix);
	CHECK_RETURN_STATUS(status)

	IVector *pLocalOrigin = NULL;
	status = activeWorkplane->GetLocalOrigin(&pLocalOrigin);
	CHECK_RETURN_STATUS(status)

	IVector *pVector4 = NULL;
	status = pTransMatrix->MultiplyByVector(pLocalOrigin, &pVector4);
	CHECK_RETURN_STATUS(status)

	status = activeWorkplane->SetLocalOrigin(pVector4);
	CHECK_RETURN_STATUS(status)

	IDirection *pDir1= NULL, *pDir2 = NULL;
	IDirection *pDir3= NULL, *pDir4 = NULL;

 	status = activeWorkplane->GetLocalX(&pDir1);
	CHECK_RETURN_STATUS(status)

 	status = activeWorkplane->GetLocalY(&pDir2);
	CHECK_RETURN_STATUS(status)

	status = pTransMatrix->MultiplyByDirection(pDir1, &pDir3);
	CHECK_RETURN_STATUS(status)

	status = pTransMatrix->MultiplyByDirection(pDir2, &pDir4);
	CHECK_RETURN_STATUS(status)

	// set the local Axes
 	status = activeWorkplane->SetLocalAxes(pDir3, pDir4);
	CHECK_RETURN_STATUS(status)

	*retval = pVector4; // returns Origin 

	END_METHOD("TranslateAxes")
}
